#ifndef GST_CU_IMAGE_METADATA_HPP
#define GST_CU_IMAGE_METADATA_HPP

#include <buildspec.h>

#include "Parsers/image_data.hpp"

#include <boost/optional.hpp>

#include <string>

namespace GST
{
namespace ClientUtils
{
// Metadata for an attached image.
//
// * (upper left, lower right) defines the specific area of the image
//   to use when displaying it in the 3D-scene.
// * depth extent, specifies the extent in the depth / z-direction.
// * Note: The location and extent in (x,y)-direction is defined by the line the
//   image is attached to.
struct GST_API_EXPORT ImageMetadata
{
	// The upper left corner in pixel-coordinates.
	// If not set, defaults to (0, 0).
	boost::optional<Parsers::ImagePixelCoordinate> upperLeft;
	// The lower right corner in pixel-coordinates.
	// If not set, defaults to (pixel-width - 1, pixel-height - 1).
	boost::optional<Parsers::ImagePixelCoordinate> lowerRight;
	// The depth / z- extent of the image in meters.
	double depthExtent;
	std::string toFeatureAttributeJson() const;
	static ImageMetadata fromFeatureAttributeJson(const std::string &json);
};

} // namespace ClientUtils
} // namespace GST

#endif // GST_CU_IMAGE_METADATA_HPP
